/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Created by inigo quilez - iq/2013
// Heavily modified by Steven An - 2014
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// I've not seen anybody out there computing correct cell interior distances for Voronoi
// patterns yet. That's why they cannot shade the cell interior correctly, and why you've
// never seen cell boundaries rendered correctly. 
//
// However, here's how you do mathematically correct distances (note the equidistant and non
// degenerated grey isolines inside the cells) and hence edges (in yellow):
//
// http://www.iquilezles.org/www/articles/voronoilines/voronoilines.htm

vec3 bg = vec3(0.15, 0.1, 0.1);
vec3 white = vec3(1.0, 1.0, 1.0);
float zoom = 0.08;
vec2 fallspeed = vec2(0.04,0.05);

float pi = 3.141592653;

#define ANIMATE

float animbias = 0.5;
float animscale = 0.4;
//float animbias = 0.0;
//float animscale = 0.0;

vec3 hash3( vec3 p )
{
	return texture2D( iChannel0, (p.xy+0.5)/(200.0), -100.0 ).xyz;
}

vec3 voronoi( in vec3 x, out vec3 cpId )
{
    vec3 n = floor(x);
    vec3 f = fract(x);

    //----------------------------------
    // first pass: regular voronoi
    //----------------------------------
	vec3 mg, mr;

    float md = 16.0;
	for( int k=-1; k<=1; k++ )
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        vec3 g = vec3(float(i),float(j), float(k));
		vec3 o = hash3( n + g );
		#ifdef ANIMATE
        o = animbias + animscale*sin( iGlobalTime*0.5 + 6.2831*o );
        #endif	
        vec3 r = g + o - f;
        float d = dot(r,r);

        if( d<md )
        {
            md = d;
            mr = r;
            mg = g;
        }
    }

    //----------------------------------
    // second pass: distance to borders
    //----------------------------------
	cpId = n+mg;

    return mr;
}

float sin01(float theta)
{
	return sin(theta)*0.5 + 0.5;
}

void main( void )
{
	float z = iGlobalTime * 0.01;
	z = 0.0;
    vec3 vs = vec3(
		(gl_FragCoord.xy-iResolution.xy*0.5)/iResolution.xx + iGlobalTime*fallspeed,
		z )/zoom;
	// add variation to sky
	bg = mix( bg, vec3(0.0,0.2,0.2), pow(gl_FragCoord.y/iResolution.y, 1.0));
	
	vec3 cpid;
    vec3 toCP = voronoi( vs, cpid );
	float centerDist = length( toCP );
	
	bg += pow(clamp(1.0-centerDist*4.0,0.0,1.0),0.9) * vec3(1,1,0.9);

	gl_FragColor = vec4( bg, 1.0);
}
